#include <sstream>
#include "itoa.h"
#include "gamma-prob.c"

struct match_result_t {

  string id;
  bool forward;

  double score;
  int start_index;
  int end_index;
  string sequence_match_string;
  string optical_match_string;

  int misses;
  double pval;
  int matches;
  double chi_square;
  double fval;

  bool operator<(const match_result_t& a) const { return score > a.score; }
  bool operator==(const match_result_t& a) const { return score == a.score; }

  string get_string(int size) {

    stringstream match_string;
    match_string << id << " " << size << " " <<  forward << " "  << start_index << " " << end_index << endl 
	       << misses << " " << chi_square << " " << pval << " " << fval << endl
	       << optical_match_string << endl << sequence_match_string << endl;

    return match_string.str();
  }
};

const double max_num_of_matches = 500;
double match_bonus;
const int small_sequence_size = 800;
 
match_result_t get_match(const pair<int, int>& end_index, double** score, pair<int, int>** last,
			 const vector<int>& sequence_pieces, const vector<pair<int, int> >& optical_pieces, 
			 string id, bool forward) {

  pair<int, int> index = end_index;
  set<int> optical_set; set<int> sequence_set;

  while(index.first >= 0 && index.second >= 0) {

    index = last[index.first][index.second];
    sequence_set.insert(index.first);
    optical_set.insert(index.second);
  }

  match_result_t result; 
  result.id = id; result.forward = forward;
  result.score = score[end_index.first][end_index.second]; 
  result.misses = int(abs(result.score/match_bonus)); result.matches = sequence_set.size()-1;
  result.chi_square = abs(result.score+result.misses*match_bonus);
  result.pval = (result.misses/double(2*result.matches+result.misses) <= error_rate ? 0 : 
		 1-betai(result.misses, 2*result.matches+1, error_rate));            
  result.fval = 1;

  result.start_index = index.second+1;
  result.end_index = end_index.second;

  for(int i = index.first+1; i <= end_index.first; i++)
    result.sequence_match_string += string(itoa(sequence_pieces[i])) +
      (sequence_set.count(i) == 1 ? "; " : " ");

  for(int j = result.start_index; j <= result.end_index; j++)
    result.optical_match_string += string(itoa(optical_pieces[j].first)) + "," 
      + string(itoa(optical_pieces[j].second)) + (optical_set.count(j) == 1 ? "; " : " ");

  return result;
}

match_result_t match(const vector<int>& sequence_pieces, const vector<pair<int, int> >& optical_pieces,
		     bool match_others, vector<match_result_t>& others, string id, bool forward) {

  double** score = new double*[sequence_pieces.size()];
  pair<int, int>** last = new pair<int, int>*[sequence_pieces.size()];

  for(int i = 0; i < sequence_pieces.size(); i++) {
    score[i] = new double[optical_pieces.size()];
    last[i] = new pair<int, int>[optical_pieces.size()];
  }
  
  double best_score = -INF; pair<int, int> best_index;

  for(int i = 0; i < sequence_pieces.size(); i++)
    for(int j = 0; j < optical_pieces.size(); j++) {

      score[i][j] = -INF; last[i][j] = pair<int, int>(-1, -1);      

      int optical_size = 0;
      int var = 0;

      for(int l = j; l >= 0; l--) {
      //for(int l = j; l >= MAX(j-2*sequence_pieces.size(), 0); l--) {

	optical_size += optical_pieces[l].first;
	var += optical_pieces[l].second*optical_pieces[l].second;

	if(optical_pieces[l].second == 0)
	  break;

	int sequence_size = 0;
	for(int k = i; k >= 0; k--) {
	  sequence_size += sequence_pieces[k];
	  
	  if(l-1 >= 0 || k-1 < 0)
	    if(i == 0 || i == sequence_pieces.size()-1) {
	      
	      if(optical_size + current_sd*sqrt((double) var) > sequence_size) {
		
		double curr_score = -match_bonus*(j-l + i-k) 
		  + (k-1 >= 0 ? score[k-1][l-1] : 0);
		
		if(curr_score > score[i][j]) {
		  
		  score[i][j] = curr_score;
		  last[i][j] = pair<int, int>(k-1, l-1);
		}
	      }
	    }
	    else {
	      
	      double num_of_sd = abs(optical_size-sequence_size)/sqrt((double) var);
	      
	      if(num_of_sd <= current_sd) {
		
		double curr_score = -match_bonus*(j-l + i-k) - pow(num_of_sd,2)
		  + (k-1 >= 0 ? score[k-1][l-1] : 0);
		
		if(curr_score > score[i][j]) {
		  
		  score[i][j] = curr_score;
		  last[i][j] = pair<int, int>(k-1, l-1);
		}
	      }
	    }
	}
      }

      if(i+1 == sequence_pieces.size() && score[i][j] > best_score) {
	
	best_score = score[i][j];
	best_index = pair<int, int>(i, j);
      }
    }

  match_result_t result = get_match(best_index, score, last, sequence_pieces, optical_pieces, id, forward);

  if(match_others)
    for(int j = 0; j < optical_pieces.size(); j++) {
      
      if(j == best_index.second)
	continue;
      
      if(int(result.score/match_bonus) == int(score[best_index.first][j]/match_bonus)) {
	
	pair<int, int> index(best_index.first, j);
	match_result_t other = get_match(index, score, last, sequence_pieces, optical_pieces, id, forward);
	others.push_back(other);
      }
    }
  
  for(int i = 0; i < sequence_pieces.size(); i++) {
    delete[](score[i]);
    delete[](last[i]);
  }

  delete[](score);
  delete[](last);
  
  return result;
}
