#include <cstdlib>
#include <list>
#include <map>
#include <string>
#include <iostream>
#include <sstream>
#include <fstream>

using namespace std;

string OPT_MatchFile;

struct job_t {

  string id;
  int start;
  int end;
  double weight;
  double curr_w;
  string printString;

  bool overlap(const job_t& other_job) {

    return ((start >= other_job.start && start <= other_job.end) ||
	    (end >= other_job.start && end <= other_job.end));
  }

  bool operator<(const job_t& other_job) {

    return (end < other_job.end);
  }

  bool operator==(const job_t& other_job) {

    if(id == other_job.id || overlap(other_job))
      curr_w -= other_job.weight;
    
    return (curr_w <= 0);
  }

};

struct schedule_t {

  list<job_t> jobs;
  double weight;

  schedule_t() : weight(0) {}
};

void greedy_schedule(list<job_t>& to_schedule, schedule_t& result, map<string, bool>& scheduled) {

  if(to_schedule.empty())
    return;
  else {

    job_t selected_job = to_schedule.front(); to_schedule.pop_front();
    to_schedule.remove(selected_job);
	
    greedy_schedule(to_schedule, result, scheduled);
    if(result.jobs.empty() || 
       (!scheduled[selected_job.id] && selected_job.end < result.jobs.front().start)) {

      result.jobs.push_front(selected_job);
      result.weight += selected_job.weight;
      scheduled[selected_job.id] = true;
    }
  }
}

void exhaustive_schedule(list<job_t> to_schedule, schedule_t& result, map<string, bool>& scheduled, double remaining_weight, double& lower_bound) {

  if(!to_schedule.empty() && result.weight+remaining_weight >= lower_bound) {

    job_t selected_job = to_schedule.front(); to_schedule.pop_front();
    schedule_t copy = result;
    exhaustive_schedule(to_schedule, result, scheduled, remaining_weight-selected_job.weight, lower_bound);
    
    if(copy.jobs.empty() ||
       (!scheduled[selected_job.id] && selected_job.start > copy.jobs.back().end)) {

      copy.jobs.push_back(selected_job); copy.weight += selected_job.weight;

      scheduled[selected_job.id] = true;
      exhaustive_schedule(to_schedule, copy, scheduled, remaining_weight-selected_job.weight, lower_bound);
      scheduled[selected_job.id] = false;

      if(copy.weight > result.weight)
	result = copy;
    }
  }

  if(result.weight > lower_bound)
    lower_bound = result.weight;
}

int main(int argc, char ** argv) {

  OPT_MatchFile = argv[1]; OPT_MatchFile += "/seq";
  ifstream match_file((OPT_MatchFile + ".rest").c_str());

  job_t job; list<job_t> all_jobs;
  map<string, bool> scheduled; double total_weight = 0; double scores[5]; int forward;

  while(match_file >> job.id >> scores[0] >> forward >> job.start >> job.end 
	>> scores[1] >> scores[2] >> scores[3] >> scores[4]) {
   
    job.curr_w = job.weight = scores[atoi(argv[2])]; job.printString = "";

    stringstream ss; 
    ss << job.id << " " << scores[0] << " " << forward << " " << job.start << " " << job.end << endl;
    ss << scores[1] << " " << scores[2] << " " << scores[3] << " " << scores[4] << endl;

    job.printString += ss.str();
    string line; getline(match_file, line); 
    for(int i = 1; i <= 3; i++) {

      getline(match_file, line); 
      job.printString += line + "\n";
    }

    total_weight += job.weight;
    scheduled[job.id] = false;
    all_jobs.push_back(job);
  }

  match_file.close();

  all_jobs.sort();

  schedule_t greedy_result;
  list<job_t> all_jobs_copy = all_jobs; map<string, bool> scheduled_copy = scheduled;
  greedy_schedule(all_jobs_copy, greedy_result, scheduled_copy);

  ofstream greedy_file((OPT_MatchFile + ".greedy").c_str());

  for(list<job_t>::iterator it = greedy_result.jobs.begin(); it != greedy_result.jobs.end(); it++)
    greedy_file << it->printString;

  greedy_file.close();

  if(all_jobs.size() < 40) {

    schedule_t result; double lower_bound = greedy_result.weight;
    exhaustive_schedule(all_jobs, result, scheduled, total_weight, lower_bound);

    ofstream exhaustive_file((OPT_MatchFile + ".exhaustive").c_str());

    for(list<job_t>::iterator it = result.jobs.begin(); it != result.jobs.end(); it++)
      exhaustive_file << it->printString;

    exhaustive_file.close();
  }

  return EXIT_SUCCESS;
}
