//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2003, The Institute for Genomic Research (TIGR), Rockville,
// Maryland, U.S.A.  All rights reserved.
//////////////////////////////////////////////////////////////////////////////
/* Generated by Together */

#ifndef DATASETABSTRACTFACTORY_H
#define DATASETABSTRACTFACTORY_H
#include "DataSetAbstractProduct.h"
#include <string>

class DataSetAbstractProduct;
class DnaStr;

/**
 * <b>Purpose:</b><br>
 * Defines the standard interface for input data source factories<br>
 * These factories are responsible for parsing input files and storing them<br>
 * in apropriate datastructures (typically a list of genome coordinates so far).<br>
 * <b>Pattern:</b> Abstract Factory (Design Patterns Gamma et. al)
 * @stereotype abstractfactory 
 */
class DataSetAbstractFactory {
public:

    /**
     * <b>Precond:</b><br>
     * Takes as input a string specifing a "flat" file where the input data is stored<br>
     * @param const string& (1) => the file name to read data from
     * @param const string& (2) => a unique string identifier to associate with the evidence source
     * @param const string& (3) => type of evidence, "geneprediction", "spliceprediction", "homology"
     *                             some factorys can read formats that can produce different
     *                             types of evidence, such as "GFF" format.
     * e.g. homology, geneprediction etc. 
     */
  virtual DataSetAbstractProduct * createDataSetAbstractProduct(const string&,const string&,const string&, const std::string&) =0;
private:

    /**
     * @link
     * @shapeType PatternLink
     * @pattern Abstract Factory
     * @clientRole Factory
     * @supplierRole Product 
     */
    /*# DataSetAbstractProduct _dataSetAbstractProduct; */

    /**
     * @link
     * @shapeType PatternLink
     * @pattern Abstract Factory
     * @supplierRole Concrete factory 
     */
    /*# AnonDataSetConcreteFactory _anonDataSetConcreteFactory; */
};
#endif //DATASETABSTRACTFACTORY_H
