//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2003, The Institute for Genomic Research (TIGR), Rockville,
// Maryland, U.S.A.  All rights reserved.
//////////////////////////////////////////////////////////////////////////////
/* Generated by Together */

#ifndef DATASETABSTRACTPRODUCT_H
#define DATASETABSTRACTPRODUCT_H
#include <vector>
#include <list>
#include <pair.h>
#include <assert.h>
#include "Prediction.h"

/**
 * <b>Responsibilities:</b><br>
 * Defines the basic behavior of all input data sets, whether it be<br>
 * gene prediction data, splice site site data, EST matches or some as of<br>
 * yet undetermined source.  This class is a container class meaning that<br>
 * it is both a Sequence Location in of itself and a collection of Sequence Locations.<br>
 * It is a sequence location that stores the boundaries of the collection of sequence<br>
 * locations.  The main algorithm interfaces with this class via the class <i>InputData</i><br>
 * which is just a aggregation of these objects.  The purpose of this object is to shield the <br>
 * dynamic programming algorithm from dealing with specific data sources.<br>
 * <b>Pattern:</b> Container (Design Patterns Gamma et. al)
 * <b>Collaborators:</b><br>
 * SeqLoc, DataSetAbstractFactory, InputData.
 * @stereotype container 
 */
class DataSetAbstractProduct : public Prediction {
public:
  friend std::ostream& operator<<(std::ostream&, const DataSetAbstractProduct&);
  typedef DataStorageType::iterator iterator;
  typedef DataStorageType::const_iterator const_iterator;
  /** 
   * @param SeqLoc - associated sequence location
   * @param int - id usually 0 or -1, needs to be phased out
   * @param string - a source identifier, user defined
   * @param AnnotationScore - initialize to badVal usually
   */
  DataSetAbstractProduct(const SeqLoc&, int, const string&, AnnotationScore); 

  void sort();

  /**
   * some derived times store temporary hash
   * tables to speed up reading in data
   * method provides a universal way of
   * removing temp data
   */
  virtual void del_temp() { }

  /**
   * stores a linked list
   */
  virtual ~DataSetAbstractProduct();

  /**
   * deletes contents from memory
   */
  virtual void del();

  DataStorageType* makePlaceHolders() const;

  /**
   * interface to the list return the last element
   */
  const Prediction* getLast() const;
  /**
   * interface to the list of associated predictions
   */
  iterator begin();

  /**
   * interface to the list of associated predictions
   */
  const_iterator begin() const;

  /**
   * interface to the list of associated predictions
   */
  const_iterator end() const;

  /**
   * interface to the list of associated predictions
   */
  iterator end();

  /**
   * number of elements in prediction list
   */
  unsigned size() const;

  /**
   * true if no prediction list
   */
  bool empty() const { return lnkSeqLoc.empty(); }

  /**
   * standard print display
   */
  virtual void print(std::ostream&, const string&) const;

  /** 
   * add a new prediction
   */
  void insert(Prediction*);
  void sort_insert(Prediction*);

  /**
   * When this container represents a collection of gene predictions
   * from a program that does not explicitely report the introns
   * we want to try making the intron regions explicit
   */
  virtual void add_introns();

  const Prediction* getClosestEnd3Exon(int,int) const;
  int getClosestEnd5(int) const;

  /**
   * @param int X - 5' index
   * returns the closest 5' index
   * <= X
   */
  const Prediction* getClosestEnd5Exon(int) const;

  /**
   * @param int - a 5' index
   * @param int - a 3' index
   * return the prediction that overlaps a particular
   * input index location, returns null if none exists
   */
  void getRelatedPrediction(int,int,std::list<const Prediction*>&) const;
  /**
   * @param int - 5' index, look for match
   **/
  void getRelatedPrediction5(int,std::list<const Prediction*>&) const;

  /**
   * @param int - 3' index, look for match
   **/
  void getRelatedPrediction3(int,std::list<const Prediction*>&) const;

  /* not used right now */
  pair<const Prediction*,const Prediction*>
    getRelatedPredictionInterval(int,int) const;

  pair<const Prediction*,const Prediction*>
    getIntronBoundaries(int,int) const;

  const Prediction* getRelatedPrediction(int) const;

  int getListPos(const Prediction*) const;

  void erase(DataStorageType::iterator iter) { lnkSeqLoc.erase(iter); }

protected:
  virtual void add_introns_help();

    /**
     * @link
     * @shapeType PatternLink
     * @pattern Abstract Factory
     * @supplierRole Factory
     * @hidden 
     */
    /*# DataSetAbstractFactory _dataSetAbstractFactory; */

    /**
     * @link
     * @shapeType PatternLink
     * @pattern Abstract Factory
     * @supplierRole Concrete product 
     */
    /*# AnonDataSet _anonDataSet; */

    /** @link aggregation 
     * @clientCardinality 0..**/
    DataStorageType lnkSeqLoc;
};

#endif //DATASETABSTRACTPRODUCT_H
